using System;
using System.Data;
using System.Text;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;
using Method = System.Reflection.MethodBase;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


namespace gov.va.med.vbecs.BOL
{
	/// <summary>
	/// Summary description for PatientRecordReport.
	/// </summary>
	public class PatientRecordReport:VbecsReport
	{
		private BOL.Patient _patient;
        private DataSet _dsReportData = new DataSet();
		//private bool _includePatientDemographics;
		//private bool _includePatientTransfusionRequirements;
		//private bool _includePatientTesting;
		//private bool _includePatientUnitAssignments;
		//private bool _includePatientTransfusions;
		//private bool _includePatientSpecimens;
		//private bool _includePatientSpecialInstructions;
		//private bool _includePatientTransfusionReactions;
		//private bool _includePatientExceptionReports;
		//private DataTable _patientRecordReport;

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5523"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Initialized PatientRecordReport object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5524"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// PatientRecordReport empty constructor
		/// </summary>
		public PatientRecordReport()
		{
			this.IncludePatientDemographics = true;
			this.IncludePatientTransfusionRequirements = true;
			this.IncludePatientTesting = true;
			this.IncludePatientUnitAssignments = true;
			this.IncludePatientTransfusions = true;
			this.IncludePatientSpecimens = true;
			this.IncludePatientSpecialInstructions = true;
			this.IncludePatientTransfusionReactions = true;
			this.IncludePatientExceptionReports = false;
		}

//		/// <summary>
//		/// Gets patient for  reporting
//		/// </summary>
//		public BOL.Patient Patient
//		{
//			get
//			{
//				return this._patient;
//			}
//		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="5525"> 
		///		<ExpectedInput>Valid PatientRecordReport object</ExpectedInput>
		///		<ExpectedOutput>Patient property</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5526"> 
		///		<ExpectedInput>Valid patient guid</ExpectedInput>
		///		<ExpectedOutput>Updated PatientRecordReport object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5527"> 
		///		<ExpectedInput>Invalid patient guid</ExpectedInput>
		///		<ExpectedOutput>Rule Broken</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets or sets Patient unique identifier
		/// </summary>
		public Guid PatientGuid
		{
			get
			{
				return (Guid)this.ParameterRow[TABLE.Patient.PatientGuid];
			}
			set
			{
				if (value != Guid.Empty)
				{
					this._patient = new BOL.Patient(value);
				}
				//
				this.ParameterRow[TABLE.Patient.PatientGuid] = value;
				//
				RuleBroken("Patient", (value == Guid.Empty));
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="5528"> 
		///		<ExpectedInput>Valid PatientRecordReport object</ExpectedInput>
		///		<ExpectedOutput>IncludePatientDemographics property of true</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5529"> 
		///		<ExpectedInput>IncludePatientDemographics flag set to true</ExpectedInput>
		///		<ExpectedOutput>Updated PatientRecordReport object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5530"> 
		///		<ExpectedInput>IncludePatientDemographics flag set to false</ExpectedInput>
		///		<ExpectedOutput>Rule Broken</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets or sets flag indicating whether the patient demographic section is included in the report
		/// Implements BR_101.01
		/// </summary>
		public bool IncludePatientDemographics
		{
			get
			{
				if (this.ParameterRow.IsNull(ARTIFICIAL.IncludePatientDemographics))
				{
					return false;
				}
				return Convert.ToBoolean(this.ParameterRow[ARTIFICIAL.IncludePatientDemographics]);
			}
			set
			{
				this.ParameterRow[ARTIFICIAL.IncludePatientDemographics] = value;
				//
				RuleBroken("ReportSections", (!this.IncludePatientDemographics &&
					!this.IncludePatientExceptionReports &&
					!this.IncludePatientSpecialInstructions &&
					!this.IncludePatientSpecimens &&
					!this.IncludePatientTesting &&
					!this.IncludePatientTransfusionReactions &&
					!this.IncludePatientTransfusionRequirements &&
					!this.IncludePatientTransfusions &&
					!this.IncludePatientUnitAssignments));
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="5531"> 
		///		<ExpectedInput>Valid PatientRecordReport object</ExpectedInput>
		///		<ExpectedOutput>IncludePatientTransfusionRequirements property of true</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5532"> 
		///		<ExpectedInput>IncludePatientTransfusionRequirements flag set to true</ExpectedInput>
		///		<ExpectedOutput>Updated PatientRecordReport object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5533"> 
		///		<ExpectedInput>IncludePatientTransfusionRequirements flag set to false</ExpectedInput>
		///		<ExpectedOutput>Rule Broken</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets or sets flag indicating whether the patient transfusion requirements section is included in the report
		/// Implements BR_101.01
		/// </summary>
		public bool IncludePatientTransfusionRequirements
		{
			get
			{
				if (this.ParameterRow.IsNull(ARTIFICIAL.IncludePatientTransfusionRequirements))
				{
					return false;
				}
				return Convert.ToBoolean(this.ParameterRow[ARTIFICIAL.IncludePatientTransfusionRequirements]);
			}
			set
			{
				this.ParameterRow[ARTIFICIAL.IncludePatientTransfusionRequirements] = value;
				//
				RuleBroken("ReportSections", (!this.IncludePatientDemographics &&
					!this.IncludePatientExceptionReports &&
					!this.IncludePatientSpecialInstructions &&
					!this.IncludePatientSpecimens &&
					!this.IncludePatientTesting &&
					!this.IncludePatientTransfusionReactions &&
					!this.IncludePatientTransfusionRequirements &&
					!this.IncludePatientTransfusions &&
					!this.IncludePatientUnitAssignments));
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="5534"> 
		///		<ExpectedInput>Valid PatientRecordReport object</ExpectedInput>
		///		<ExpectedOutput>IncludePatientTesting property of true</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5535"> 
		///		<ExpectedInput>IncludePatientTesting flag set to true</ExpectedInput>
		///		<ExpectedOutput>Updated PatientRecordReport object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5536"> 
		///		<ExpectedInput>IncludePatientTesting flag set to false</ExpectedInput>
		///		<ExpectedOutput>Rule Broken</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets or sets flag indicating whether the patient testing section is included in the report
		/// Implements BR_101.01
		/// </summary>
		public bool IncludePatientTesting
		{
			get
			{
				if (this.ParameterRow.IsNull(ARTIFICIAL.IncludePatientTesting))
				{
					return false;
				}
				return Convert.ToBoolean(this.ParameterRow[ARTIFICIAL.IncludePatientTesting]);
			}
			set
			{
				this.ParameterRow[ARTIFICIAL.IncludePatientTesting] = value;
				//
				RuleBroken("ReportSections", (!this.IncludePatientDemographics &&
					!this.IncludePatientExceptionReports &&
					!this.IncludePatientSpecialInstructions &&
					!this.IncludePatientSpecimens &&
					!this.IncludePatientTesting &&
					!this.IncludePatientTransfusionReactions &&
					!this.IncludePatientTransfusionRequirements &&
					!this.IncludePatientTransfusions &&
					!this.IncludePatientUnitAssignments));
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="5537"> 
		///		<ExpectedInput>Valid PatientRecordReport object</ExpectedInput>
		///		<ExpectedOutput>IncludePatientUnitAssignment property of true</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5538"> 
		///		<ExpectedInput>IncludePatientUnitAssignment flag set to true</ExpectedInput>
		///		<ExpectedOutput>Updated PatientRecordReport object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5539"> 
		///		<ExpectedInput>IncludePatientUnitAssignment flag set to false</ExpectedInput>
		///		<ExpectedOutput>Rule Broken</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets or sets flag indicating whether the patient unit assignment section is included in the report
		/// Implements BR_101.01
		/// </summary>
		public bool IncludePatientUnitAssignments
		{
			get
			{
				if (this.ParameterRow.IsNull(ARTIFICIAL.IncludePatientUnitAssignments))
				{
					return false;
				}
				return Convert.ToBoolean(this.ParameterRow[ARTIFICIAL.IncludePatientUnitAssignments]);
			}
			set
			{
				this.ParameterRow[ARTIFICIAL.IncludePatientUnitAssignments] = value;
				//
				RuleBroken("ReportSections", (!this.IncludePatientDemographics &&
					!this.IncludePatientExceptionReports &&
					!this.IncludePatientSpecialInstructions &&
					!this.IncludePatientSpecimens &&
					!this.IncludePatientTesting &&
					!this.IncludePatientTransfusionReactions &&
					!this.IncludePatientTransfusionRequirements &&
					!this.IncludePatientTransfusions &&
					!this.IncludePatientUnitAssignments));
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="5540"> 
		///		<ExpectedInput>Valid PatientRecordReport object</ExpectedInput>
		///		<ExpectedOutput>IncludePatientTransfusions property of true</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5541"> 
		///		<ExpectedInput>IncludePatientTransfusions flag set to true</ExpectedInput>
		///		<ExpectedOutput>Updated PatientRecordReport object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5542"> 
		///		<ExpectedInput>IncludePatientTransfusions flag set to false</ExpectedInput>
		///		<ExpectedOutput>Rule Broken</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets or sets flag indicating whether the patient transfusion section is included in the report
		/// Implements BR_101.01
		/// </summary>
		public bool IncludePatientTransfusions
		{
			get
			{
				if (this.ParameterRow.IsNull(ARTIFICIAL.IncludePatientTransfusions))
				{
					return false;
				}
				return Convert.ToBoolean(this.ParameterRow[ARTIFICIAL.IncludePatientTransfusions]);
			}
			set
			{
				this.ParameterRow[ARTIFICIAL.IncludePatientTransfusions] = value;
				//
				RuleBroken("ReportSections", (!this.IncludePatientDemographics &&
					!this.IncludePatientExceptionReports &&
					!this.IncludePatientSpecialInstructions &&
					!this.IncludePatientSpecimens &&
					!this.IncludePatientTesting &&
					!this.IncludePatientTransfusionReactions &&
					!this.IncludePatientTransfusionRequirements &&
					!this.IncludePatientTransfusions &&
					!this.IncludePatientUnitAssignments));
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="5543"> 
		///		<ExpectedInput>Valid PatientRecordReport object</ExpectedInput>
		///		<ExpectedOutput>IncludePatientSpecimens property of true</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5544"> 
		///		<ExpectedInput>IncludePatientSpecimens flag set to true</ExpectedInput>
		///		<ExpectedOutput>Updated PatientRecordReport object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5545"> 
		///		<ExpectedInput>IncludePatientSpecimens flag set to false</ExpectedInput>
		///		<ExpectedOutput>Rule Broken</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets or sets flag indicating whether the patient specimen section is included in the report
		/// Implements BR_101.01
		/// </summary>
		public bool IncludePatientSpecimens
		{
			get
			{
				if (this.ParameterRow.IsNull(ARTIFICIAL.IncludePatientSpecimens))
				{
					return false;
				}
				return Convert.ToBoolean(this.ParameterRow[ARTIFICIAL.IncludePatientSpecimens]);
			}
			set
			{
				this.ParameterRow[ARTIFICIAL.IncludePatientSpecimens] = value;
				//
				RuleBroken("ReportSections", (!this.IncludePatientDemographics &&
					!this.IncludePatientExceptionReports &&
					!this.IncludePatientSpecialInstructions &&
					!this.IncludePatientSpecimens &&
					!this.IncludePatientTesting &&
					!this.IncludePatientTransfusionReactions &&
					!this.IncludePatientTransfusionRequirements &&
					!this.IncludePatientTransfusions &&
					!this.IncludePatientUnitAssignments));
			}		
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="5546"> 
		///		<ExpectedInput>Valid PatientRecordReport object</ExpectedInput>
		///		<ExpectedOutput>IncludePatientSpecialInstructions property of true</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5547"> 
		///		<ExpectedInput>IncludePatientSpecialInstructions flag set to true</ExpectedInput>
		///		<ExpectedOutput>Updated PatientRecordReport object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5548"> 
		///		<ExpectedInput>IncludePatientSpecialInstructions flag set to false</ExpectedInput>
		///		<ExpectedOutput>Rule Broken</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets or sets flag indicating whether the patient special instructions section is included in the report
		/// Implements BR_101.01
		/// </summary>
		public bool IncludePatientSpecialInstructions
		{
			get
			{
				if (this.ParameterRow.IsNull("IncludePatientSpecialInstructions"))
				{
					return false;
				}
				return Convert.ToBoolean(this.ParameterRow["IncludePatientSpecialInstructions"]);
			}
			set
			{
				this.ParameterRow["IncludePatientSpecialInstructions"] = value;
				//
				RuleBroken("ReportSections", (!this.IncludePatientDemographics &&
					!this.IncludePatientExceptionReports &&
					!this.IncludePatientSpecialInstructions &&
					!this.IncludePatientSpecimens &&
					!this.IncludePatientTesting &&
					!this.IncludePatientTransfusionReactions &&
					!this.IncludePatientTransfusionRequirements &&
					!this.IncludePatientTransfusions &&
					!this.IncludePatientUnitAssignments));
			}		
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="5549"> 
		///		<ExpectedInput>Valid PatientRecordReport object</ExpectedInput>
		///		<ExpectedOutput>IncludePatientTransfusionReactions property of true</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5550"> 
		///		<ExpectedInput>IncludePatientTransfusionReactions flag set to true</ExpectedInput>
		///		<ExpectedOutput>Updated PatientRecordReport object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5551"> 
		///		<ExpectedInput>IncludePatientTransfusionReactions flag set to false</ExpectedInput>
		///		<ExpectedOutput>Rule Broken</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets or sets flag indicating whether the patient transfusion reaction section is included in the report
		/// Implements BR_101.01
		/// </summary>
		public bool IncludePatientTransfusionReactions
		{
			get
			{
				if (this.ParameterRow.IsNull(ARTIFICIAL.IncludePatientTransfusionReactions))
				{
					return false;
				}
				return Convert.ToBoolean(this.ParameterRow[ARTIFICIAL.IncludePatientTransfusionReactions]);
			}
			set
			{
				this.ParameterRow[ARTIFICIAL.IncludePatientTransfusionReactions] = value;
				//
				RuleBroken("ReportSections", (!this.IncludePatientDemographics &&
					!this.IncludePatientExceptionReports &&
					!this.IncludePatientSpecialInstructions &&
					!this.IncludePatientSpecimens &&
					!this.IncludePatientTesting &&
					!this.IncludePatientTransfusionReactions &&
					!this.IncludePatientTransfusionRequirements &&
					!this.IncludePatientTransfusions &&
					!this.IncludePatientUnitAssignments));
			}		
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/16/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="5552"> 
		///		<ExpectedInput>Valid PatientRecordReport object</ExpectedInput>
		///		<ExpectedOutput>IncludePatientExceptionReports property of false</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5553"> 
		///		<ExpectedInput>IncludePatientExceptionReports flag set to true</ExpectedInput>
		///		<ExpectedOutput>Updated PatientRecordReport object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5554"> 
		///		<ExpectedInput>IncludePatientExceptionReports flag set to false</ExpectedInput>
		///		<ExpectedOutput>Rule Broken</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets or sets falg indicating whether the patient exception report section is included in the report
		/// Implements BR_101.01, BR_101.03
		/// </summary>
		public bool IncludePatientExceptionReports
		{
			get
			{
				if (this.ParameterRow.IsNull(ARTIFICIAL.IncludePatientExceptionReports))
				{
					return false;
				}
				return Convert.ToBoolean(this.ParameterRow[ARTIFICIAL.IncludePatientExceptionReports]);
			}
			set
			{
				this.ParameterRow[ARTIFICIAL.IncludePatientExceptionReports] = value;
				//
				RuleBroken("ReportSections", (!this.IncludePatientDemographics &&
					!this.IncludePatientExceptionReports &&
					!this.IncludePatientSpecialInstructions &&
					!this.IncludePatientSpecimens &&
					!this.IncludePatientTesting &&
					!this.IncludePatientTransfusionReactions &&
					!this.IncludePatientTransfusionRequirements &&
					!this.IncludePatientTransfusions &&
					!this.IncludePatientUnitAssignments));
			}		
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5555"> 
		///		<ExpectedInput>Valid PatientRecordReport object</ExpectedInput>
		///		<ExpectedOutput>Report criteria string for report footer</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5561"> 
		///		<ExpectedInput>Invalid PatientRecordReport object (No patient defined)</ExpectedInput>
		///		<ExpectedOutput>Business Object Exception thrown</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5556"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets report criteria text for Patient History report footer
		/// </summary>
		public string ReportCriteria
		{
			get
			{
				if ((this.PatientGuid == Guid.Empty))
				{
					throw new BusinessObjectException(Common.StrRes.SysErrMsg.UC001.NoPatientFound().ResString);
				}
				//
				StringBuilder criteria = new StringBuilder();
				criteria.Append("Patient: "+this._patient.DisplayName+"\n");
				criteria.Append("Sections Included:\n");
				if (this.IncludePatientDemographics)
				{
					criteria.Append("Demographics ");
				}
				if (this.IncludePatientSpecimens)
				{
					criteria.Append("Specimens ");
				}
				if (this.IncludePatientTesting)
				{
					criteria.Append("Testing ");
				}
				if (this.IncludePatientUnitAssignments)
				{
					criteria.Append("Unit Assignments ");
				}
				if (this.IncludePatientTransfusions)
				{
					criteria.Append("Transfusions ");
				}
				if (this.IncludePatientTransfusionReactions)
				{
					criteria.Append("Transfusion Reactions ");
				}
				if (this.IncludePatientTransfusionRequirements)
				{
					criteria.Append("Transfusion Requirements ");
				}
				if (this.IncludePatientSpecialInstructions)
				{
					criteria.Append("Special Instructions ");
				}
				if (this.IncludePatientExceptionReports)
				{
					criteria.Append("Exception Report ");
				}
				//
				return criteria.ToString();
			}
		}

		/// <summary>
		/// Format Patient Demographics Section For reports
		/// </summary>
		/// <param name="ds">Report data set to be formatted</param>
		private DataSet FormatPatientDemographicsSectionForReports(DataSet ds)
		{
			int nCount = 0;
			string abo = string.Empty,rh = string.Empty;
			//
			DataTable dt = ds.Tables[TABLE.Patient.TableName];
			dt.Columns.Add(ARTIFICIAL.MergeFromPatientDisplayName);
			dt.Columns.Add(ARTIFICIAL.MergeToPatientDisplayName);
			dt.Columns.Add(ARTIFICIAL.PatientDisplayName);
			dt.Columns.Add(ARTIFICIAL.ABORh);
			dt.Columns.Add("PatientSex");
			foreach(DataRow dr in dt.Rows)
			{
				abo = dr[TABLE.Patient.BloodTypeCode].ToString();
				rh = dr[TABLE.Patient.RhFactorCode].ToString().Trim();
				//
				dr[ARTIFICIAL.PatientDisplayName] = BOL.Patient.BuildDisplayName(dr[TABLE.Patient.PatientFirstName].ToString(),
					dr[TABLE.Patient.PatientMiddleName].ToString(),dr[TABLE.Patient.PatientLastName].ToString());
				dr[ARTIFICIAL.ABORh] = new AboRh(Common.Utility.GetAboFromString(abo),Common.Utility.GetRhFromString(rh)).AboRHText;
				char sex = dr.IsNull(TABLE.Patient.PatientSexCode) ? char.MinValue : Convert.ToChar(dr[TABLE.Patient.PatientSexCode]);
				dr["PatientSex"] = Common.Utility.GetSexEnumFromSexChar(sex).ToString();
				if (!dr.IsNull(TABLE.Patient.MergeFromPatient))
				{
					dr[ARTIFICIAL.MergeFromPatientDisplayName] = BOL.Patient.BuildDisplayName(dr[ARTIFICIAL.MergeFromPatientFirstName].ToString(),
						dr[ARTIFICIAL.MergeFromPatientMiddleName].ToString(),dr["MergeFromPatientLastName"].ToString());
				}
				if (!dr.IsNull(TABLE.Patient.MergeToPatient))
				{
					dr[ARTIFICIAL.MergeToPatientDisplayName] = BOL.Patient.BuildDisplayName(dr[ARTIFICIAL.MergeToPatientFirstName].ToString(),
						dr[ARTIFICIAL.MergeToPatientMiddleName].ToString(),dr[ARTIFICIAL.MergeToPatientLastName].ToString());
				}
			}
			//
			DataTable dtAboRHHistoryCopy = ds.Tables[TABLE.Compatibility.PatientAboRh].Copy();
			//
			DataTable dtAboRHHistory = ds.Tables[TABLE.Compatibility.PatientAboRh];
			dtAboRHHistory.Columns.Add(ARTIFICIAL.ABORh);
			dtAboRHHistory.Rows.Clear();
			//

            foreach (DataColumn col in dtAboRHHistory.Columns)
            {
                col.AllowDBNull = true;
            }
            ////Now go through specimen test results to set ABO/Rh text
			nCount = dtAboRHHistoryCopy.Rows.Count;
			for(int i=0; i<nCount; i++)
			{
				DataRow dr = dtAboRHHistoryCopy.Rows[i];
				//Add 1st Vbecs ABO/Rh test result and any subsequent changes
				if ((i==0) || ((bool)dr[TABLE.SpecimenTest.AboRhChangeIndicator]))
				{
					DataRow drAboRH = dtAboRHHistory.NewRow();
					drAboRH[TABLE.VamcDivision.DivisionCode] = dr[TABLE.VamcDivision.DivisionCode];
					drAboRH[TABLE.VamcDivision.DivisionName] = dr[TABLE.VamcDivision.DivisionName];
					drAboRH[ARTIFICIAL.ABORh] = new AboRh(Common.Utility.GetAboFromString(dr[TABLE.Patient.BloodTypeCode].ToString()),
						Common.Utility.GetRhFromString(dr[TABLE.Patient.RhFactorCode].ToString().Trim())).AboRHText;
					drAboRH[TABLE.SpecimenTest.AboRhChangeIndicator] = dr[TABLE.SpecimenTest.AboRhChangeIndicator];
					drAboRH[TABLE.SpecimenTest.AboRhChangeJustification] = dr[TABLE.SpecimenTest.AboRhChangeJustification];
					drAboRH[TABLE.SpecimenTest.LastUpdateDate] = dr[TABLE.SpecimenTest.LastUpdateDate];
					drAboRH[TABLE.SpecimenTest.LastUpdateUser] = dr[TABLE.SpecimenTest.LastUpdateUser];
					dtAboRHHistory.Rows.InsertAt(drAboRH,0);
				}
			}
			//
			BOL.AboRh vistaAboRh = new AboRh(Common.Utility.GetAboFromString(abo),Common.Utility.GetRhFromString(rh));
			if ((vistaAboRh.AboRHText != "NR")||(dtAboRHHistory.Rows.Count==0))
			{
				DataRow drVistaAboRH = dtAboRHHistory.NewRow();
				if (vistaAboRh.AboRHText != "NR")
				{
					drVistaAboRH[TABLE.VamcDivision.DivisionName] = "From Legacy Record";
				}
				drVistaAboRH[ARTIFICIAL.ABORh] = vistaAboRh.AboRHText;
				dtAboRHHistory.Rows.Add(drVistaAboRH);
			}
			//
			DataSet dsReturn = new DataSet();
			dsReturn.Tables.Add(dt.Copy());
           
            dtAboRHHistory.PrimaryKey = new DataColumn[0];
            dsReturn.Tables.Add(dtAboRHHistory.Copy());
			return dsReturn;
		}

		/// <summary>
		/// Format Patient Specimen Section For reports
		/// </summary>
		/// <param name="ds">Report data set to be formatted</param>
		private DataTable FormatPatientSpecimenSectionForReports(DataSet ds)
		{
			DataTable dt = ds.Tables[TABLE.PatientSpecimen.TableName].Copy();
			foreach(DataRow dr in dt.Rows)
			{
				if (!dr.IsNull(TABLE.CannedComment.CannedCommentGuid))
				{
					dr[ARTIFICIAL.PatientSpecimenCommentText] = BOL.CannedComment.CombinedComment((Guid)dr[TABLE.CannedComment.CannedCommentGuid],dr[ARTIFICIAL.PatientSpecimenCommentText].ToString());
				}
				//
				if ((!dr.IsNull(TABLE.PatientSpecimen.UnacceptableSpecimenIndicator)) && 
					((bool)dr[TABLE.PatientSpecimen.UnacceptableSpecimenIndicator]))
				{
					dr[TABLE.SpecimenStatus.SpecimenStatusText] = "Unacceptable";
				}
				else if ((!dr.IsNull(TABLE.PatientSpecimen.SpecimenExpirationDate)) &&
					(Convert.ToDateTime(dr[TABLE.PatientSpecimen.SpecimenExpirationDate]) < BOL.VBECSDateTime.GetDivisionCurrentDateTime()))
				{
					dr[TABLE.SpecimenStatus.SpecimenStatusText] = "Expired";
				}
			}
			//
			return BOL.VbecsReport.MultiDivisionalSort(dt);
		}

		/// <summary>
		/// Format Patient Testing Section For reports
		/// </summary>
		/// <param name="ds">Report data set to be formatted</param>
		private DataTable FormatPatientTestingSectionForReports(DataSet ds)
		{
			DataTable dt = ds.Tables[TABLE.SpecimenTest.TableName].Copy();
			dt.Columns.Add(TABLE.PatientTest.TestResult);
			dt.Columns.Add(ARTIFICIAL.TestUniqueId);
			dt.Columns.Add(ARTIFICIAL.TestOrderUniqueId);
			dt.Columns.Add(ARTIFICIAL.ReportTestName);
			foreach(DataRow dr in dt.Rows)
			{
				if ((Convert.ToInt32(dr[TABLE.OrderableTest.OrderableTestId])==Convert.ToInt32(Common.OrderableTest.ABID))||
					(Convert.ToInt32(dr[TABLE.OrderableTest.OrderableTestId])==Convert.ToInt32(Common.OrderableTest.RepeatABID)))
				{
					if (dr.IsNull(TABLE.AntibodyType.AntibodyTypeName))
					{
						dr[TABLE.PatientTest.TestResult] = "None identified";
					}
					else
					{
						dr[TABLE.PatientTest.TestResult] = dr[TABLE.AntibodyType.AntibodyTypeName].ToString();
					}
				}
				else
				{
					dr[TABLE.PatientTest.TestResult] = dr[TABLE.TestResult.TestResultText].ToString();
				}
				//
				dr[ARTIFICIAL.TestOrderUniqueId] = dr["TestOrderGuid"].ToString();
				//
				dr[ARTIFICIAL.TestUniqueId] = dr[ARTIFICIAL.TestGuid].ToString();
				//
				if (!dr.IsNull(TABLE.BloodTestType.ReportableTestId))
				{
					if (((int)dr[TABLE.BloodTestType.ReportableTestId]==(int)Common.OrderableTest.ABORh)||
						((int)dr[TABLE.BloodTestType.ReportableTestId]==(int)Common.OrderableTest.RepeatABORh))
					{
						dr[ARTIFICIAL.ReportTestName] = dr[TABLE.OrderableTest.OrderableTestText].ToString()+" ("+dr[TABLE.BloodTestType.BloodTestName].ToString().Replace(" Interp","")+")";
					}
					else
					{
						dr[ARTIFICIAL.ReportTestName] = dr[TABLE.OrderableTest.OrderableTestText].ToString()+" ("+dr["ReportableTestText"].ToString()+")";
					}
				}
				else
				{
					if ((int)dr[TABLE.OrderableTest.OrderableTestId]==(int)Common.OrderableTest.ABORh)
					{
						dr[ARTIFICIAL.ReportTestName] = dr[TABLE.BloodTestType.BloodTestName].ToString().Replace(" Interp","");
					}
					else if ((int)dr[TABLE.OrderableTest.OrderableTestId]==(int)Common.OrderableTest.RepeatABORh)
					{
						dr[ARTIFICIAL.ReportTestName] = "Repeat "+dr[TABLE.BloodTestType.BloodTestName].ToString().Replace(" Interp","");
					}
					else
					{
						dr[ARTIFICIAL.ReportTestName] = dr[TABLE.OrderableTest.OrderableTestText].ToString();
					}
				}
				//
				if (((int)dr[TABLE.OrderableTest.OrderableTestId]==(int)Common.OrderableTest.XM)||
					((int)dr[TABLE.OrderableTest.OrderableTestId]==(int)Common.OrderableTest.RepeatXM))
				{
					dr[ARTIFICIAL.ReportTestName] = dr[ARTIFICIAL.ReportTestName]+" ("+dr[TABLE.BloodUnit.EyeReadableUnitId].ToString()+", "+dr[ARTIFICIAL.FullProductCode].ToString().Trim()+")";
				}
				//
				if (!dr.IsNull(TABLE.CannedComment.CannedCommentGuid))
					dr[TABLE.SpecimenTest.TestComments] = BOL.CannedComment.CombinedComment((Guid)dr[TABLE.CannedComment.CannedCommentGuid],dr[TABLE.SpecimenTest.TestComments].ToString());
			}
			//
			return VbecsReport.MultiDivisionalSort(dt);
		}

		/// <summary>
		/// Format Patient Unit Assignment Section For reports
		/// </summary>
		/// <param name="ds">Report data set to be formatted</param>
		private DataTable FormatPatientUnitAssignmentSectionForReports(DataSet ds)
		{
			DataTable dt = ds.Tables[TABLE.OrderedUnit.TableName].Copy();
			dt.Columns.Add("GroupByGuidAsString");
			foreach(DataRow dr in dt.Rows)
			{
				if (!dr.IsNull(ARTIFICIAL.PooledUnitsCount))
				{
					if (Convert.ToInt32(dr[ARTIFICIAL.PooledUnitsCount]) > 0)
					{
						dr[TABLE.BloodProduct.ProductShortName] = dr[TABLE.BloodProduct.ProductShortName].ToString()+" ("+dr[ARTIFICIAL.PooledUnitsCount].ToString()+")";
					}
				}
				//
				if (!dr.IsNull(TABLE.CannedComment.CannedCommentGuid))
				{
					dr[TABLE.OrderedUnitComment.OrderedUnitCommentText] = BOL.CannedComment.CombinedComment((Guid)dr[TABLE.CannedComment.CannedCommentGuid],dr[TABLE.OrderedUnitComment.OrderedUnitCommentText].ToString());
				}
				//
				//SSRS won't group on Guid.. so turning it into a string!!
				dr["GroupByGuidAsString"] = dr[TABLE.OrderedUnit.OrderedUnitGuid].ToString();
			}
			//
			return VbecsReport.MultiDivisionalSort(dt);
		}

		/// <summary>
		/// Format Patient Transfusion Section For reports
		/// </summary>
		/// <param name="ds">Report data set to be formatted</param>
		private DataTable FormatPatientTransfusionSectionForReports(DataSet ds)
		{
			DataTable dt = ds.Tables[TABLE.PatientTransfusion.TableName].Copy();
			dt.Columns.Add("GroupByGuidAsString");
			dt.Columns.Add(ARTIFICIAL.TransfusionistIds);
			foreach(DataRow dr in dt.Rows)
			{
				if (!dr.IsNull(ARTIFICIAL.PooledUnitsCount))
				{
					if (Convert.ToInt32(dr[ARTIFICIAL.PooledUnitsCount]) > 0)
					{
						dr[TABLE.BloodProduct.ProductShortName] = dr[TABLE.BloodProduct.ProductShortName].ToString()+" ("+dr[ARTIFICIAL.PooledUnitsCount].ToString()+")";
					}
				}
				//
				if (dr[TABLE.PatientTransfusion.Transfusionist1Id].ToString().Trim().Length>0)
				{
					if (dr[TABLE.PatientTransfusion.Transfusionist2Id].ToString().Trim().Length>0)
					{
						dr[ARTIFICIAL.TransfusionistIds] = dr[TABLE.PatientTransfusion.Transfusionist1Id].ToString()+" & "+dr[TABLE.PatientTransfusion.Transfusionist2Id].ToString();
					}
					else
					{
						dr[ARTIFICIAL.TransfusionistIds] = dr[TABLE.PatientTransfusion.Transfusionist1Id].ToString();
					}
				}
				else
				{
					dr[ARTIFICIAL.TransfusionistIds] = dr[TABLE.PatientTransfusion.Transfusionist2Id].ToString();
				}
				//
				if (!dr.IsNull(TABLE.CannedComment.CannedCommentGuid))
				{
					dr[TABLE.PatientTransfusionComment.PatientTransfusionCommentText] = BOL.CannedComment.CombinedComment((Guid)dr[TABLE.CannedComment.CannedCommentGuid],dr[TABLE.PatientTransfusionComment.PatientTransfusionCommentText].ToString());
				}
				//
				//SSRS won't group on Guid.. so turning it into a string!!
				dr["GroupByGuidAsString"] = dr[TABLE.PatientTransfusion.PatientTransfusionGuid].ToString();
			}
			//
			return VbecsReport.MultiDivisionalSort(dt);
		}

		/// <summary>
		/// Format Patient Transfusion Reaction Section For reports
		/// </summary>
		/// <param name="ds">Report data set to be formatted</param>
		private DataTable FormatPatientTransfusionReactionSectionForReports(DataSet ds)
		{
			//
			DataTable dt = ds.Tables[TABLE.PatientTransfusionReaction.TableName].Copy();
			//
			//SSRS won't group on Guid.. so turning it into a string!!
			dt.Columns.Add("GroupByPatientTransfusionReaction");
			//
			dt.Columns.Add(TABLE.PatientSymptom.PatientSymptomName);
			dt.Columns.Add(ARTIFICIAL.PatientSymptomDateEntered,typeof(DateTime));
			dt.Columns.Add(ARTIFICIAL.PatientSymptomEnteredBy);
			//
			dt.Columns.Add(ARTIFICIAL.ImplicatedUnitIds);
			dt.Columns.Add(ARTIFICIAL.ImplicatedProductNames);
			dt.Columns.Add(ARTIFICIAL.ImplicatedClericalChecks);
			dt.Columns.Add(ARTIFICIAL.ImplicatedHemolysis);
			dt.Columns.Add(ARTIFICIAL.ImplicatedBagReturned);
			dt.Columns.Add(ARTIFICIAL.ImplicatedDateEntered,typeof(DateTime));
			dt.Columns.Add(ARTIFICIAL.ImplicatedEnteredBy);
			dt.Columns.Add(ARTIFICIAL.ImplicatedComment);
			//
			dt.Columns.Add(TABLE.ExceptionPatientTest.TestName);
			dt.Columns.Add(TABLE.PatientTest.TestResult);
			dt.Columns.Add(TABLE.BloodTestType.TestedWith);
			dt.Columns.Add(TABLE.RackTest.TestDate);
			dt.Columns.Add(ARTIFICIAL.TestedBy);
			dt.Columns.Add(ARTIFICIAL.AutoInstrument);
			dt.Columns.Add(TABLE.Rack.RackName);
			dt.Columns.Add(TABLE.BloodUnitTest.TestComments);
			dt.Columns.Add(ARTIFICIAL.TestDateEntered,typeof(DateTime));
			dt.Columns.Add(ARTIFICIAL.TestEnteredBy);
			//
			foreach(DataRow dr in dt.Rows)
			{
				dr["GroupByPatientTransfusionReaction"] = dr[TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid].ToString();
				//
				if (!dr.IsNull(ARTIFICIAL.PreNACannedCommentGuid))
				{
					dr[ARTIFICIAL.PreNACommentText] = BOL.CannedComment.CombinedComment((Guid)dr[ARTIFICIAL.PreNACannedCommentGuid],dr[ARTIFICIAL.PreNACommentText].ToString());
				}
				if (!dr.IsNull(ARTIFICIAL.PostNACannedCommentGuid))
				{
					dr[ARTIFICIAL.PostNACommentText] = BOL.CannedComment.CombinedComment((Guid)dr[ARTIFICIAL.PostNACannedCommentGuid],dr[ARTIFICIAL.PostNACommentText].ToString());
				}
				if (!dr.IsNull(ARTIFICIAL.PreCCCannedCommentGuid))
				{
					dr[ARTIFICIAL.PreCCCommentText] = BOL.CannedComment.CombinedComment((Guid)dr[ARTIFICIAL.PreCCCannedCommentGuid],dr[ARTIFICIAL.PreCCCommentText].ToString());
				}
				if (!dr.IsNull(ARTIFICIAL.PostCCCannedCommentGuid))
				{
					dr[ARTIFICIAL.PostCCCommentText] = BOL.CannedComment.CombinedComment((Guid)dr[ARTIFICIAL.PostCCCannedCommentGuid],dr[ARTIFICIAL.PostCCCommentText].ToString());
				}
				//
				if (!dr.IsNull(TABLE.PatientTransfusionReaction.RecordStatusCode))
				{
					if (Common.Utility.GetRecordStatusCodeFromString(dr[TABLE.PatientTransfusionReaction.RecordStatusCode].ToString()) == Common.RecordStatusCode.Converted)
					{
						dr[TABLE.VamcDivision.DivisionName] = "VistA Converted";
					}
				}
				//
				DataRow[] drSymptoms = ds.Tables[TABLE.PatientTransfusionReactionSymptom.TableName].Select(TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid+" = '"+dr[TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid].ToString()+"'");
				string symptoms = "";
				if (drSymptoms != null)
				{
					bool firstentry = true;
					foreach(DataRow drSymptom in drSymptoms)
					{
						if (Convert.ToInt32(drSymptom[TABLE.PatientSymptom.PatientSymptomId]) == 21)
						{
							string freeTextSymptom = "";
							//
							freeTextSymptom = drSymptom[TABLE.PatientSymptom.PatientSymptomName].ToString()+": ";
							if (!drSymptom.IsNull(TABLE.PatientTransfusionComment.CannedCommentGuid))
							{
								freeTextSymptom += BOL.CannedComment.CombinedComment((Guid)drSymptom[TABLE.PatientTransfusionComment.CannedCommentGuid],drSymptom[TABLE.PatientTransfusionComment.PatientTransfusionCommentText].ToString());
							}
							else
							{
								freeTextSymptom+=drSymptom[TABLE.PatientTransfusionComment.PatientTransfusionCommentText].ToString();
							}
							//
							symptoms+=(freeTextSymptom+"\n");
						}
						else
						{
							symptoms+=(drSymptom[TABLE.PatientSymptom.PatientSymptomName].ToString()+"\n");
						}
						if (firstentry)
						{
							dr[ARTIFICIAL.PatientSymptomDateEntered] = drSymptom[TABLE.PatientTransfusionReactionSymptom.LastUpdateDate];
							dr[ARTIFICIAL.PatientSymptomEnteredBy] = drSymptom[TABLE.PatientTransfusionReactionSymptom.LastUpdateUser];
							firstentry = false;
						}
					}
				}
				dr[TABLE.PatientSymptom.PatientSymptomName] = symptoms;
				//
				DataRow[] drUnits = ds.Tables[TABLE.TransfusionReaction.TableName].Select(TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid+" = '"+dr[TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid].ToString()+"'");
				string unitids = "",products = "",checks = "",hemolysis = "",bags = "",comments = "";
				if (drUnits != null)
				{
					bool firstentry = true;
					foreach(DataRow drUnit in drUnits)
					{
						unitids+=(drUnit[TABLE.BloodUnit.EyeReadableUnitId].ToString()+"\n");
						products+=(drUnit[TABLE.BloodProduct.ProductShortName].ToString()+"\n");
						if ((!drUnit.IsNull(TABLE.TransfusionReaction.BagReturnedIndicator)) && ((bool)drUnit[TABLE.TransfusionReaction.BagReturnedIndicator]))
						{
							bags+="Yes\n";
							if ((!drUnit.IsNull(TABLE.TransfusionReaction.BagClericalChecksOkIndicator)) && ((bool)drUnit[TABLE.TransfusionReaction.BagClericalChecksOkIndicator]))
							{
								checks+="Yes\n";
							}
							else
							{
								checks+="No\n";
							}
							hemolysis+=(drUnit[TABLE.HemolysisInspection.HemolysisInspectionText].ToString()+"\n");
							//
							//Clerical checks comment
							if (!drUnit.IsNull(ARTIFICIAL.CheckCannedCommentGuid))
							{
								comments += (BOL.CannedComment.CombinedComment((Guid)drUnit[ARTIFICIAL.CheckCannedCommentGuid],drUnit[ARTIFICIAL.CheckCommentText].ToString())+"\n");
							}
							else
							{
								comments += (drUnit[ARTIFICIAL.CheckCommentText].ToString()+"\n");
							}
						}
						else
						{
							bags+="No\n";
							checks+="\n";
							hemolysis+="\n";
							//
							//Not returned comment
							if (!drUnit.IsNull(ARTIFICIAL.BagCannedCommentGuid))
							{
								comments += (BOL.CannedComment.CombinedComment((Guid)drUnit[ARTIFICIAL.BagCannedCommentGuid],drUnit[ARTIFICIAL.BagCommentText].ToString())+"\n");
							}
							else
							{
								comments += (drUnit[ARTIFICIAL.BagCommentText].ToString()+"\n");
							}
						}
						//
						if (firstentry)
						{
							dr[ARTIFICIAL.ImplicatedDateEntered] = drUnit[TABLE.TransfusionReaction.LastUpdateDate];
							dr[ARTIFICIAL.ImplicatedEnteredBy] = drUnit[TABLE.TransfusionReaction.LastUpdateUser];
							firstentry = false;
						}
					}
				}
				dr[ARTIFICIAL.ImplicatedUnitIds] = unitids;
				dr[ARTIFICIAL.ImplicatedProductNames] = products;
				dr[ARTIFICIAL.ImplicatedClericalChecks] = checks;
				dr[ARTIFICIAL.ImplicatedHemolysis] = hemolysis;
				dr[ARTIFICIAL.ImplicatedBagReturned] = bags;
				dr[ARTIFICIAL.ImplicatedComment] = comments;
				//
				DataRow[] drTests = ds.Tables["TrwSerologicTests"].Select(TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid+" = '"+dr[TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid].ToString()+"'");
				string testnames = "", testresults = "", testedwith = "";//,testcomments = "";
				if (drTests != null)
				{
					bool firstentry = true;
					foreach(DataRow drTest in drTests)
					{
						testnames+=(drTest[TABLE.BloodTestType.BloodTestName].ToString()+"\n");
						testresults+=(drTest[TABLE.TestResult.TestResultText].ToString()+"\n");
						if (drTest.IsNull(TABLE.BloodUnit.EyeReadableUnitId))
						{
							testedwith+=(drTest[TABLE.PatientSpecimen.SpecimenUid].ToString()+"\n");
						}
						else
						{
							testedwith+=(drTest[TABLE.BloodUnit.EyeReadableUnitId].ToString()+", "+drTest[ARTIFICIAL.FullProductCode].ToString().Trim()+"\n");
						}
						//testcomments+=(drTest[TABLE.SpecimenTest.TestComments].ToString()+"\n");
						//
						if (firstentry)
						{
							dr[TABLE.RackTest.TestDate] = Common.VBECSDateTime.FormatDateTimeString(drTest[TABLE.SpecimenTest.TestDate]);
							dr[ARTIFICIAL.TestedBy] = drTest[TABLE.SpecimenTest.TestTechId].ToString();
							dr[ARTIFICIAL.AutoInstrument] = drTest[TABLE.SpecimenTest.AutoInstrumentName].ToString();
							dr[TABLE.Rack.RackName]= drTest[TABLE.Rack.RackName].ToString();
							dr[ARTIFICIAL.TestDateEntered] = drTest["EntryDate"];
							dr[ARTIFICIAL.TestEnteredBy] = drTest[TABLE.SpecimenTest.EntryTechId];
							dr[TABLE.BloodUnitTest.TestComments] = drTest[TABLE.SpecimenTest.TestComments].ToString();
							firstentry = false;
						}
					}
				}
				dr[TABLE.ExceptionPatientTest.TestName] = testnames;
				dr[TABLE.PatientTest.TestResult] = testresults;
				dr[TABLE.BloodTestType.TestedWith] = testedwith;
				//dr[TABLE.BloodUnitTest.TestComments] = testcomments;
			}
			//
			return VbecsReport.MultiDivisionalSort(dt);
			//
			//ds.Tables.Remove(TABLE.PatientTransfusionReactionSymptom.TableName);
			//ds.Tables.Remove(TABLE.TransfusionReaction.TableName);
			//ds.Tables.Remove("TrwSerologicTests");
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5557"> 
		///		<ExpectedInput>Valid PatientRecordReport object</ExpectedInput>
		///		<ExpectedOutput>Count of records in patient record report</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5558"> 
		///		<ExpectedInput>Invalid division code and null patient</ExpectedInput>
		///		<ExpectedOutput>Null Reference Exception thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns a count of the number of expected entries in the report, based on report criteria
		/// </summary>
		/// <returns>Record count</returns>
		public int GetPatientRecordReportCount()
		{
			return DAL.PatientRecordReport.GetPatientRecordReportCount(this.PatientGuid,
				Common.LogonUser.LogonUserDivisionCode,
				this.IncludePatientDemographics,
				this.IncludePatientSpecimens,
				this.IncludePatientTesting,
				this.IncludePatientUnitAssignments,
				this.IncludePatientTransfusions,
				this.IncludePatientTransfusionReactions,
				this.IncludePatientTransfusionRequirements,
				this.IncludePatientSpecialInstructions,
				this.IncludePatientExceptionReports);
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5559"> 
		///		<ExpectedInput>Valid PatientRecordReport object</ExpectedInput>
		///		<ExpectedOutput>Patient record report data set</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5560"> 
		///		<ExpectedInput>Invalid division code and null patient</ExpectedInput>
		///		<ExpectedOutput>Null Reference Exception thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns the patient record report as a dataset, for use in reports
		/// Implemements BR_101.01, BR_35.15
		/// </summary>
		/// <returns>Report data set</returns>
		public DataSet GetPatientRecordReport()
		{
			DataSet ds = DAL.PatientRecordReport.GetPatientRecordReport(this.PatientGuid, 
				Common.LogonUser.LogonUserDivisionCode,
				this.IncludePatientDemographics,
				this.IncludePatientSpecimens,
				this.IncludePatientTesting,
				this.IncludePatientUnitAssignments,
				this.IncludePatientTransfusions,
				this.IncludePatientTransfusionReactions,
				this.IncludePatientTransfusionRequirements,
				this.IncludePatientSpecialInstructions,
				this.IncludePatientExceptionReports);
			//
			DataSet dsReturn = new DataSet();
			//
			if (this.IncludePatientDemographics)
			{
				DataSet dsDemographics = this.FormatPatientDemographicsSectionForReports(ds);
				dsReturn.Tables.Add(dsDemographics.Tables[0].Copy());
                //dsReturn.Tables[0].WriteXml("e:\\temp\\PatientHistoryDemographicsDataSet1.xml", XmlWriteMode.WriteSchema);
				dsReturn.Tables.Add(dsDemographics.Tables[1].Copy());
                //dsReturn.Tables[1].WriteXml("e:\\temp\\PatientHistoryDemographicsDataSet2.xml", XmlWriteMode.WriteSchema);
            }
			//BR_35.15
			if (this.IncludePatientSpecimens)
			{
				dsReturn.Tables.Add(this.FormatPatientSpecimenSectionForReports(ds).Copy());
                //dsReturn.Tables[2].WriteXml("e:\\temp\\PatientSpecimenHistoryDataSet.xml", XmlWriteMode.WriteSchema);
            }
			//
			if (this.IncludePatientTesting)
			{
				dsReturn.Tables.Add(this.FormatPatientTestingSectionForReports(ds).Copy());
               // dsReturn.Tables[3].WriteXml("e:\\temp\\PatientTestingHistoryDataSet.xml", XmlWriteMode.WriteSchema);
            }
			//
			if (this.IncludePatientUnitAssignments)
			{
				dsReturn.Tables.Add(this.FormatPatientUnitAssignmentSectionForReports(ds).Copy());
               // dsReturn.Tables[4].WriteXml("e:\\temp\\PatientUnitAssignmentHistoryDataSet.xml", XmlWriteMode.WriteSchema);
            }
			//
			if (this.IncludePatientTransfusions)
			{
				dsReturn.Tables.Add(this.FormatPatientTransfusionSectionForReports(ds).Copy());
                //dsReturn.Tables[5].WriteXml("e:\\temp\\PatientTransfusionHistoryDataSet.xml", XmlWriteMode.WriteSchema);
            }
			//
			if (this.IncludePatientTransfusionReactions)
			{
				dsReturn.Tables.Add(this.FormatPatientTransfusionReactionSectionForReports(ds).Copy());
                //dsReturn.Tables[6].WriteXml("e:\\temp\\PatientTransfusionReactionHistoryDataSet.xml", XmlWriteMode.WriteSchema);
            }
			//
			if (this.IncludePatientTransfusionRequirements)
			{
				foreach(DataRow dr in ds.Tables[TABLE.PatientTransfusionRequirement.TableName].Rows)
				{
					if (!dr.IsNull(TABLE.PatientTransfusionRequirement.VistaConversionIndicator))
					{
						if (Convert.ToBoolean(dr[TABLE.PatientTransfusionRequirement.VistaConversionIndicator]))
						{
							dr["CreateDivisionName"] = "VistA Converted";
						}
					}
				}
				dsReturn.Tables.Add(VbecsReport.MultiDivisionalSort(ds.Tables[TABLE.PatientTransfusionRequirement.TableName].Copy()));
               // dsReturn.Tables[7].WriteXml("e:\\temp\\PatientTransfusionRequirementsDataSet.xml", XmlWriteMode.WriteSchema);
            }
			//
			if (this.IncludePatientSpecialInstructions)
			{
				foreach(DataRow dr in ds.Tables[TABLE.PatientSpecialInstruction.TableName].Rows)
				{
					if (!dr.IsNull(TABLE.PatientSpecialInstruction.VistaConversionIndicator))
					{
						if (Convert.ToBoolean(dr[TABLE.PatientSpecialInstruction.VistaConversionIndicator]))
						{
							dr[TABLE.VamcDivision.DivisionName] = "VistA Converted";
						}
					}
				}
				dsReturn.Tables.Add(VbecsReport.MultiDivisionalSort(ds.Tables[TABLE.PatientSpecialInstruction.TableName].Copy()));
                //dsReturn.Tables[8].WriteXml("e:\\temp\\PatientSpecialInstructionsHistoryDataSet.xml", XmlWriteMode.WriteSchema);
            }
			//
			if (this.IncludePatientExceptionReports)
			{
				dsReturn.Tables.Add(ds.Tables[Common.ExceptionReportType.ExceptionReportQCNotPerformed.ToString()].Copy());
				dsReturn.Tables.Add(ds.Tables[Common.ExceptionReportType.ExceptionReportQC.ToString()].Copy());
				dsReturn.Tables.Add(ds.Tables[Common.ExceptionReportType.ExceptionReportReflexTest.ToString()].Copy());
				dsReturn.Tables.Add(ds.Tables[Common.ExceptionReportType.ExceptionReportSpecimen.ToString()].Copy());
				dsReturn.Tables.Add(ds.Tables[Common.ExceptionReportType.ExceptionReportPatientAboRh.ToString()].Copy());
				dsReturn.Tables.Add(ds.Tables[Common.ExceptionReportType.ExceptionReportPatientAboRhDiscrepancy.ToString()].Copy());
				dsReturn.Tables.Add(ds.Tables[Common.ExceptionReportType.ExceptionReportPatientTest.ToString()].Copy());
				dsReturn.Tables.Add(ds.Tables[Common.ExceptionReportType.ExceptionReportPatientTestInactivated.ToString()].Copy());
				dsReturn.Tables.Add(ds.Tables[Common.ExceptionReportType.ExceptionReportPatientAntigenDiscrepancy.ToString()].Copy());
				dsReturn.Tables.Add(ds.Tables[Common.ExceptionReportType.ExceptionReportUnitSelection.ToString()].Copy());
				dsReturn.Tables.Add(ds.Tables[Common.ExceptionReportType.ExceptionReportTrwSpecimen.ToString()].Copy());
				dsReturn.Tables.Add(ds.Tables[Common.ExceptionReportType.ExceptionReportTransfusionReactionWorkup.ToString()].Copy());
				dsReturn.Tables.Add(ds.Tables[Common.ExceptionReportType.ExceptionReportCautionTagBTRFPrinting.ToString()].Copy());
				dsReturn.Tables.Add(ds.Tables[Common.ExceptionReportType.ExceptionReportReturnIssuedUnit.ToString()].Copy());
				dsReturn.Tables.Add(ds.Tables[Common.ExceptionReportType.ExceptionReportTransfusion.ToString()].Copy());
				dsReturn.Tables.Add(ds.Tables[Common.ExceptionReportType.ExceptionReportUnitIssue.ToString()].Copy());
				dsReturn.Tables.Add(ds.Tables[Common.ExceptionReportType.ExceptionReportEmergencyIssueOrder.ToString()].Copy());
				dsReturn.Tables.Add(ds.Tables[Common.ExceptionReportType.ExceptionReportUnitERIssuedTestingProblem.ToString()].Copy());
				dsReturn.Tables.Add(ds.Tables[Common.ExceptionReportType.ExceptionReportPatientRestriction.ToString()].Copy());
			}
			//
			return AddPatientRecordReportSectionDetails(dsReturn);
		}

		/// <summary>
		/// Adds Patient Record Report Section Details to report data set
		/// Implemements BR_101.02, BR_101.04
		/// </summary>
		/// <param name="reportDataSet">Report data set</param>
		/// <returns>Updated report data set</returns>
		private DataSet AddPatientRecordReportSectionDetails(DataSet reportDataSet)
		{
			DataTable dt = new DataTable("ReportSections");
			dt.Columns.Add(ARTIFICIAL.PatientDisplayName);
			dt.Columns.Add(TABLE.Patient.DisplayVistaPatientId);
			dt.Columns.Add(ARTIFICIAL.ABORh);
			dt.Columns.Add(TABLE.Patient.PatientSexCode);
			dt.Columns.Add(TABLE.Patient.PatientDob,typeof(DateTime));
			dt.Columns.Add(TABLE.Patient.AboRhChangeIndicator,typeof(bool));
			dt.Columns.Add("CheckLegacyRecords",typeof(bool));
			dt.Columns.Add("IncludeDemographicSection",typeof(bool));
			dt.Columns.Add("DemographicSectionRecordCount", typeof(int));
			dt.Columns.Add("IncludeSpecimenSection",typeof(bool));
			dt.Columns.Add("SpecimenSectionRecordCount", typeof(int));
			dt.Columns.Add("IncludeTestingSection",typeof(bool));
			dt.Columns.Add("TestingSectionRecordCount", typeof(int));
			dt.Columns.Add("IncludeUnitAssignmentSection",typeof(bool));
			dt.Columns.Add("UnitAssignmentSectionRecordCount", typeof(int));
			dt.Columns.Add("IncludeTransfusionSection",typeof(bool));
			dt.Columns.Add("TransfusionSectionRecordCount", typeof(int));
			dt.Columns.Add("IncludeTransfusionReactionSection",typeof(bool));
			dt.Columns.Add(ARTIFICIAL.TransfusionReactionSectionRecordCount, typeof(int));
			dt.Columns.Add("IncludeTransfusionRequirementSection",typeof(bool));
			dt.Columns.Add(ARTIFICIAL.TransfusionRequirementSectionRecordCount, typeof(int));
			dt.Columns.Add(ARTIFICIAL.IncludeSpecialInstructionSection,typeof(bool));
			dt.Columns.Add(ARTIFICIAL.SpecialInstructionSectionRecordCount, typeof(int));
			dt.Columns.Add(ARTIFICIAL.IncludeExceptionSection,typeof(bool));
			dt.Columns.Add("ExceptionSectionRecordCount", typeof(int));
			dt.Columns.Add("ExceptionReportQCNotPerformedRecordCount", typeof(int));
			dt.Columns.Add("ExceptionReportQCRecordCount", typeof(int));
			dt.Columns.Add("ExceptionReportReflexTestRecordCount", typeof(int));
			dt.Columns.Add("ExceptionReportSpecimenRecordCount", typeof(int));
			dt.Columns.Add("ExceptionReportPatientAboRhRecordCount", typeof(int));
			dt.Columns.Add("ExceptionReportPatientAboRhDiscrepancyRecordCount", typeof(int));
			dt.Columns.Add("ExceptionReportPatientTestRecordCount", typeof(int));
			dt.Columns.Add("ExceptionReportPatientTestInactivatedRecordCount", typeof(int));
			dt.Columns.Add("ExceptionReportPatientAntigenDiscrepancyRecordCount", typeof(int));
			dt.Columns.Add("ExceptionReportUnitSelectionRecordCount", typeof(int));
			dt.Columns.Add("ExceptionReportTrwSpecimenRecordCount", typeof(int));
			dt.Columns.Add("ExceptionReportTransfusionReactionWorkupRecordCount", typeof(int));
			dt.Columns.Add("ExceptionReportCautionTagBTRFPrintingRecordCount", typeof(int));
			dt.Columns.Add("ExceptionReportTransfusionRecordCount", typeof(int));
			dt.Columns.Add("ExceptionReportReturnIssuedUnitRecordCount", typeof(int));
			dt.Columns.Add("ExceptionReportUnitIssueRecordCount", typeof(int));
			dt.Columns.Add("ExceptionReportEmergencyIssueOrderRecordCount", typeof(int));
			dt.Columns.Add("ExceptionReportUnitERIssuedTestingProblemRecordCount", typeof(int));
			dt.Columns.Add("ExceptionReportPatientRestrictionRecordCount", typeof(int));
			//
			if (this._patient == null)
			{
				this._patient = new BOL.Patient(this.PatientGuid);
			}
			//
			DataRow dr = dt.NewRow();
			dr[ARTIFICIAL.PatientDisplayName] = this._patient.DisplayName;
			dr[TABLE.Patient.DisplayVistaPatientId] = this._patient.DisplayPatientID;
			dr[ARTIFICIAL.ABORh] = this._patient.AboRh.AboRHText;
			dr[TABLE.Patient.AboRhChangeIndicator] = this._patient.JustifiedAboRH;
			dr[TABLE.Patient.PatientSexCode] = this._patient.Sex.ToString();
			dr[TABLE.Patient.PatientDob] = this._patient.DateOfBirth;
			//
			//BR_101.04
			dr["CheckLegacyRecords"] = (this._patient.ConversionAboRH.AboRHText != "NR");
			//
			dr["IncludeDemographicSection"] = this.IncludePatientDemographics;
			if (this.IncludePatientDemographics)
			{
				dr["DemographicSectionRecordCount"] = reportDataSet.Tables[TABLE.Patient.TableName].Rows.Count+
					reportDataSet.Tables[TABLE.Compatibility.PatientAboRh].Rows.Count;
			}
			else
			{
				dr["DemographicSectionRecordCount"] = 0;
			}
			dr["IncludeSpecimenSection"] = this.IncludePatientSpecimens;
			if (this.IncludePatientSpecimens)
			{
				dr["SpecimenSectionRecordCount"] = reportDataSet.Tables[TABLE.PatientSpecimen.TableName].Rows.Count;
			}
			else
			{
				dr["SpecimenSectionRecordCount"] = 0;
			}
			dr["IncludeTestingSection"] = this.IncludePatientTesting;
			if (this.IncludePatientTesting)
			{
				dr["TestingSectionRecordCount"] = reportDataSet.Tables[TABLE.SpecimenTest.TableName].Rows.Count;
			}
			else
			{
				dr["TestingSectionRecordCount"] = 0;
			}
			dr["IncludeUnitAssignmentSection"] = this.IncludePatientUnitAssignments;
			if (this.IncludePatientUnitAssignments)
			{
				dr["UnitAssignmentSectionRecordCount"] = reportDataSet.Tables[TABLE.OrderedUnit.TableName].Rows.Count;
			}
			else
			{
				dr["UnitAssignmentSectionRecordCount"] = 0;
			}
			dr["IncludeTransfusionSection"] = this.IncludePatientTransfusions;
			if (this.IncludePatientTransfusions)
			{
				dr["TransfusionSectionRecordCount"] = reportDataSet.Tables[TABLE.PatientTransfusion.TableName].Rows.Count;
			}
			else
			{
				dr["TransfusionSectionRecordCount"] = 0;
			}
			dr["IncludeTransfusionReactionSection"] = this.IncludePatientTransfusionReactions;
			if (this.IncludePatientTransfusionReactions)
			{
				dr[ARTIFICIAL.TransfusionReactionSectionRecordCount] = reportDataSet.Tables[TABLE.PatientTransfusionReaction.TableName].Rows.Count;
			}
			else
			{
				dr[ARTIFICIAL.TransfusionReactionSectionRecordCount] = 0;
			}
			dr["IncludeTransfusionRequirementSection"] = this.IncludePatientTransfusionRequirements;
			if (this.IncludePatientTransfusionRequirements)
			{
				dr[ARTIFICIAL.TransfusionRequirementSectionRecordCount] = reportDataSet.Tables[TABLE.PatientTransfusionRequirement.TableName].Rows.Count;
			}
			else
			{
				dr[ARTIFICIAL.TransfusionRequirementSectionRecordCount] = 0;
			}
			dr[ARTIFICIAL.IncludeSpecialInstructionSection] = this.IncludePatientSpecialInstructions;
			if (this.IncludePatientSpecialInstructions)
			{
				dr[ARTIFICIAL.SpecialInstructionSectionRecordCount] = reportDataSet.Tables[TABLE.PatientSpecialInstruction.TableName].Rows.Count;
			}
			else
			{
				dr[ARTIFICIAL.SpecialInstructionSectionRecordCount] = 0;
			}
			dr[ARTIFICIAL.IncludeExceptionSection] = this.IncludePatientExceptionReports;
			if (this.IncludePatientExceptionReports)
			{
				//
				dr["ExceptionReportQCNotPerformedRecordCount"]=reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportQCNotPerformed.ToString()].Rows.Count;
				dr["ExceptionReportQCRecordCount"]=reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportQC.ToString()].Rows.Count;
				dr["ExceptionReportReflexTestRecordCount"]=reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportReflexTest.ToString()].Rows.Count;
				dr["ExceptionReportSpecimenRecordCount"]=reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportSpecimen.ToString()].Rows.Count;
				dr["ExceptionReportPatientAboRhRecordCount"]=reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportPatientAboRh.ToString()].Rows.Count;
				dr["ExceptionReportPatientAboRhDiscrepancyRecordCount"]=reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportPatientAboRhDiscrepancy.ToString()].Rows.Count;
				dr["ExceptionReportPatientTestRecordCount"]=reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportPatientTest.ToString()].Rows.Count;
				dr["ExceptionReportPatientTestInactivatedRecordCount"]=reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportPatientTestInactivated.ToString()].Rows.Count;
				dr["ExceptionReportPatientAntigenDiscrepancyRecordCount"]=reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportPatientAntigenDiscrepancy.ToString()].Rows.Count;
				dr["ExceptionReportUnitSelectionRecordCount"]=reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportUnitSelection.ToString()].Rows.Count;
				dr["ExceptionReportTrwSpecimenRecordCount"]=reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportTrwSpecimen.ToString()].Rows.Count;
				dr["ExceptionReportTransfusionReactionWorkupRecordCount"]=reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportTransfusionReactionWorkup.ToString()].Rows.Count;
				dr["ExceptionReportCautionTagBTRFPrintingRecordCount"]=reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportCautionTagBTRFPrinting.ToString()].Rows.Count;
				dr["ExceptionReportReturnIssuedUnitRecordCount"]=reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportReturnIssuedUnit.ToString()].Rows.Count;
				dr["ExceptionReportTransfusionRecordCount"]=reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportTransfusion.ToString()].Rows.Count;
				dr["ExceptionReportUnitIssueRecordCount"] = reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportUnitIssue.ToString()].Rows.Count;
				dr["ExceptionReportEmergencyIssueOrderRecordCount"] = reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportEmergencyIssueOrder.ToString()].Rows.Count;
				dr["ExceptionReportUnitERIssuedTestingProblemRecordCount"] = reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportUnitERIssuedTestingProblem.ToString()].Rows.Count;
				dr["ExceptionReportPatientRestrictionRecordCount"] = reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportPatientRestriction.ToString()].Rows.Count;
				//
				dr["ExceptionSectionRecordCount"] = reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportQCNotPerformed.ToString()].Rows.Count+
					reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportQC.ToString()].Rows.Count+
					reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportReflexTest.ToString()].Rows.Count+
					reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportSpecimen.ToString()].Rows.Count+
					reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportPatientAboRh.ToString()].Rows.Count+
					reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportPatientAboRhDiscrepancy.ToString()].Rows.Count+
					reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportPatientTest.ToString()].Rows.Count+
					reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportPatientTestInactivated.ToString()].Rows.Count+
					reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportPatientAntigenDiscrepancy.ToString()].Rows.Count+
					reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportUnitSelection.ToString()].Rows.Count+
					reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportTrwSpecimen.ToString()].Rows.Count+
					reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportTransfusionReactionWorkup.ToString()].Rows.Count+
					reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportCautionTagBTRFPrinting.ToString()].Rows.Count+
					reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportReturnIssuedUnit.ToString()].Rows.Count+
					reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportTransfusion.ToString()].Rows.Count+
					reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportUnitIssue.ToString()].Rows.Count+
					reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportEmergencyIssueOrder.ToString()].Rows.Count+
					reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportUnitERIssuedTestingProblem.ToString()].Rows.Count+
					reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportPatientRestriction.ToString()].Rows.Count;
					
			}
			else
			{
				dr["ExceptionSectionRecordCount"] = 0;
				dr["ExceptionReportQCNotPerformedRecordCount"]=0;
				dr["ExceptionReportQCRecordCount"]=0;
				dr["ExceptionReportReflexTestRecordCount"]=0;
				dr["ExceptionReportSpecimenRecordCount"]=0;
				dr["ExceptionReportPatientAboRhRecordCount"]=0;
				dr["ExceptionReportPatientAboRhDiscrepancyRecordCount"]=0;
				dr["ExceptionReportPatientTestRecordCount"]=0;
				dr["ExceptionReportPatientTestInactivatedRecordCount"]=0;
				dr["ExceptionReportPatientAntigenDiscrepancyRecordCount"]=0;
				dr["ExceptionReportUnitSelectionRecordCount"]=0;
				dr["ExceptionReportTrwSpecimenRecordCount"]=0;
				dr["ExceptionReportTransfusionReactionWorkupRecordCount"]=0;
				dr["ExceptionReportCautionTagBTRFPrintingRecordCount"]=0;
				dr["ExceptionReportReturnIssuedUnitRecordCount"]=0;
				dr["ExceptionReportTransfusionRecordCount"]=0;
				dr["ExceptionReportUnitIssueRecordCount"] = 0;
				dr["ExceptionReportEmergencyIssueOrderRecordCount"] = 0;
				dr["ExceptionReportUnitERIssuedTestingProblemRecordCount"] = 0;
				dr["ExceptionReportPatientRestrictionRecordCount"] = 0;
			}
			dt.Rows.Add(dr);
			//
			reportDataSet.Tables.Add(dt);
            //dt.WriteXml("e:\\temp\\PatientHistoryReportDataSet.xml", XmlWriteMode.WriteSchema);

			return reportDataSet;
		}

		///<Developers>
		///	<Developer></Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/12/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7559"> 
		///		<ExpectedInput>Valid patient record report onbject</ExpectedInput>
		///		<ExpectedOutput>Patient History report generated</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7560"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Generate Patient History Report
		/// </summary>
		/// <returns>Patient History Report Data Set</returns>
		public void GenerateReport()
		{
			//DataSet reportDataSet = this.GetPatientRecordReport();

/*
			gov.va.med.vbecs.reports.PatientHistoryReport.PatientHistoryReport patientHistoryReport = new gov.va.med.vbecs.reports.PatientHistoryReport.PatientHistoryReport();
			patientHistoryReport.SetDataSource(reportDataSet);
			//
			DataSet dsHeader =  BOL.VbecsReport.GetReportHeader(printedBy);
			patientHistoryReport.OpenSubreport("ReportHeader.rpt").SetDataSource(dsHeader);
			//
			string reportCriteria = this.ReportCriteria;
			DataSet dsFooter = BOL.VbecsReport.GetReportFooter(reportCriteria);
			patientHistoryReport.OpenSubreport("ReportFooter.rpt").SetDataSource(dsFooter);
			//
			if (this.IncludePatientDemographics)
			{
				patientHistoryReport.OpenSubreport("PatientDemographicHistory.rpt").SetDataSource(reportDataSet.Tables[TABLE.Patient.TableName]);
				patientHistoryReport.OpenSubreport("PatientAboRHHistory.rpt").SetDataSource(reportDataSet.Tables[TABLE.Compatibility.PatientAboRh]);
			}
			//
			if (this.IncludePatientSpecimens)
			{
				patientHistoryReport.OpenSubreport("PatientSpecimenHistory.rpt").SetDataSource(reportDataSet.Tables[TABLE.PatientSpecimen.TableName]);
			}
			//
			if (this.IncludePatientTesting)
			{
				patientHistoryReport.OpenSubreport("PatientTestingHistory.rpt").SetDataSource(reportDataSet.Tables[TABLE.SpecimenTest.TableName]);
			}
			//
			if (this.IncludePatientUnitAssignments)
			{
				patientHistoryReport.OpenSubreport("PatientUnitAssignmentHistory.rpt").SetDataSource(reportDataSet.Tables[TABLE.OrderedUnit.TableName]);
			}
			//
			if (this.IncludePatientTransfusions)
			{
				patientHistoryReport.OpenSubreport("PatientTransfusionHistory.rpt").SetDataSource(reportDataSet.Tables[TABLE.PatientTransfusion.TableName]);
			}
			//
			if (this.IncludePatientTransfusionReactions)
			{
				patientHistoryReport.OpenSubreport("PatientTransfusionReactionHistory.rpt").SetDataSource(reportDataSet);//.Tables[TABLE.PatientTransfusionReaction.TableName]);
			}
			//
			if (this.IncludePatientTransfusionRequirements)
			{
				patientHistoryReport.OpenSubreport("PatientTransfusionRequirementsHistory.rpt").SetDataSource(reportDataSet.Tables[TABLE.PatientTransfusionRequirement.TableName]);
			}
			//
			if (this.IncludePatientSpecialInstructions)
			{
				patientHistoryReport.OpenSubreport("PatientSpecialInstructionsHistory.rpt").SetDataSource(reportDataSet.Tables[TABLE.PatientSpecialInstruction.TableName]);
			}
			//
			if (this.IncludePatientExceptionReports)
			{
				patientHistoryReport.OpenSubreport("ExceptionReportQCNotPerformed.rpt").SetDataSource(reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportQCNotPerformed.ToString()]);
				patientHistoryReport.OpenSubreport("ExceptionReportQC.rpt").SetDataSource(reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportQC.ToString()]);
				patientHistoryReport.OpenSubreport("ExceptionReportReflexTest.rpt").SetDataSource(reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportReflexTest.ToString()]);
				patientHistoryReport.OpenSubreport("ExceptionReportSpecimen.rpt").SetDataSource(reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportSpecimen.ToString()]);
				patientHistoryReport.OpenSubreport("ExceptionReportPatientAboRH.rpt").SetDataSource(reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportPatientAboRh.ToString()]);
				patientHistoryReport.OpenSubreport("ExceptionReportPatientAboRHDiscrepancy.rpt").SetDataSource(reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportPatientAboRhDiscrepancy.ToString()]);
				patientHistoryReport.OpenSubreport("ExceptionReportPatientTest.rpt").SetDataSource(reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportPatientTest.ToString()]);
				patientHistoryReport.OpenSubreport("ExceptionReportPatientTestInactivated.rpt").SetDataSource(reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportPatientTestInactivated.ToString()]);
				patientHistoryReport.OpenSubreport("ExceptionReportPatientAntigenDiscrepancy.rpt").SetDataSource(reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportPatientAntigenDiscrepancy.ToString()]);
				patientHistoryReport.OpenSubreport("ExceptionReportUnitSelection.rpt").SetDataSource(reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportUnitSelection.ToString()]);
				patientHistoryReport.OpenSubreport("ExceptionReportTrwSpecimen.rpt").SetDataSource(reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportTrwSpecimen.ToString()]);
				patientHistoryReport.OpenSubreport("ExceptionReportTransfusionReactionWorkup.rpt").SetDataSource(reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportTransfusionReactionWorkup.ToString()]);
				patientHistoryReport.OpenSubreport("ExceptionReportCautionTagBTRFPrinting.rpt").SetDataSource(reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportCautionTagBTRFPrinting.ToString()]);
				patientHistoryReport.OpenSubreport("ExceptionReportReturnIssuedUnit.rpt").SetDataSource(reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportReturnIssuedUnit.ToString()]);
				patientHistoryReport.OpenSubreport("ExceptionReportTransfusion.rpt").SetDataSource(reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportTransfusion.ToString()]);
				patientHistoryReport.OpenSubreport("ExceptionReportUnitIssue.rpt").SetDataSource(reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportUnitIssue.ToString()]);
				patientHistoryReport.OpenSubreport("ExceptionReportEmergencyIssueOrder.rpt").SetDataSource(reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportEmergencyIssueOrder.ToString()]);
				patientHistoryReport.OpenSubreport("ExceptionReportUnitERIssuedTestingProblem.rpt").SetDataSource(reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportUnitERIssuedTestingProblem.ToString()]);
				patientHistoryReport.OpenSubreport("ExceptionReportPatientRestriction.rpt").SetDataSource(reportDataSet.Tables[Common.ExceptionReportType.ExceptionReportPatientRestriction.ToString()]);
			}
			*/
		}

		///<Developers>
		///	<Developer></Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/12/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7561"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7562"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Generate and print report
		/// Used by VbecsConsoleReport application
		/// </summary>
        protected override VbecsReportPrinter createReportPrinter()
		{
            _dsReportData = this.GetPatientRecordReport();
            BOL.VbecsUser user = new BOL.VbecsUser(this.PrintedBy);

            DataSet dsHeader = BOL.VbecsReport.GetReportHeader(user.UserName);
            DataSet dsFooter = BOL.VbecsReport.GetReportFooter(this.ReportCriteria);

            ReportDataSource reportSourceMain = new ReportDataSource();
            if (_dsReportData.Tables["ReportSections"].Rows.Count > 0)
            {
                reportSourceMain.Name = "PatientHistoryReportDataSet";
                reportSourceMain.Value = _dsReportData.Tables["ReportSections"];
            }

            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            ReportDataSource reportSourceFooter = new ReportDataSource();
            if (dsFooter.Tables.Count > 0)
            {
                reportSourceFooter.Name = "ReportFooterDataSet";
                reportSourceFooter.Value = dsFooter.Tables[0];
            }
            Assembly assembly = Assembly.LoadFrom(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location) + "\\Reports.dll");
            Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.PatientHistoryReport.PatientHistoryReportMain.rdlc");
            Stream streamPatientDemographic = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.PatientHistoryReport.PatientDemographicHistory.rdlc");
            Stream streamPatientAboRH = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.PatientHistoryReport.PatientAboRHHistory.rdlc");
            Stream streamPatientSpecimen = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.PatientHistoryReport.PatientSpecimenHistory.rdlc");
            Stream streamPatientTesting = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.PatientHistoryReport.PatientTestingHistory.rdlc");
            Stream streamPatientAssignment = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.PatientHistoryReport.PatientUnitAssignmentHistory.rdlc");
            Stream streamPatientTransfusion = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.PatientHistoryReport.PatientTransfusionHistory.rdlc");
            Stream streamPatientTransfusionReaction = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.PatientHistoryReport.PatientTransfusionReactionHistory.rdlc");
            Stream streamPatientTransfusionRequirements = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.PatientHistoryReport.PatientTransfusionRequirementsHistory.rdlc");
            Stream streamPatientSpecialInstructions = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.PatientHistoryReport.PatientSpecialInstructionsHistory.rdlc");
            Stream streamExceptionPatientAboRh = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionPatientAboRh.rdlc");
            Stream streamExceptionPatientAboRhDiscrepancy = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionPatientAboRhDiscrepancy.rdlc");
            Stream streamExceptionPatientAntigenDiscrepancy = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionPatientAntigenDiscrepancy.rdlc");
            Stream streamExceptionPatientTest = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionPatientTest.rdlc");
            Stream streamExceptionPatientTestInactivated = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionPatientTestInactivated.rdlc");
            Stream streamExceptionQCNotPerformed = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionQCNotPerformed.rdlc");
            Stream streamExceptionQC = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionQC.rdlc");
            Stream streamExceptionReflexTest = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionReflexTest.rdlc");
            Stream streamExceptionSpecimen = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionSpecimen.rdlc");
            Stream streamExceptionUnitSelection = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionUnitSelection.rdlc");
            Stream streamExceptionTrwSpecimen = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionTrwSpecimen.rdlc");
            Stream streamExceptionTransfusionReactionWorkup = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionTransfusionReactionWorkup.rdlc");
            Stream streamExceptionCautionTagBTRFPrinting = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionCautionTagBTRFPrinting.rdlc");
            Stream streamExceptionReturnIssuedUnit = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionReturnIssuedUnit.rdlc");
            Stream streamExceptionTransfusion = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionTransfusion.rdlc");
            Stream streamExceptionUnitIssue = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionUnitIssue.rdlc");
            Stream streamExceptionEmergencyIssueOrder = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionEmergencyIssueOrder.rdlc");
            Stream streamExceptionUnitERIssuedTestingProblem = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionUnitERIssuedTestingProblem.rdlc");
            Stream streamExceptionPatientRestriction = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionPatientRestriction.rdlc");

            LocalReport report = new LocalReport();
            report.SubreportProcessing += new SubreportProcessingEventHandler(LoadSubreportsEventHandler);

            report.DataSources.Add(reportSourceMain);
            report.DataSources.Add(reportSourceHeader);
            report.DataSources.Add(reportSourceFooter);
            report.LoadReportDefinition(stream);
            report.LoadSubreportDefinition("PatientDemographicHistory", streamPatientDemographic);
            report.LoadSubreportDefinition("PatientAboRHHistory", streamPatientAboRH);
            report.LoadSubreportDefinition("PatientSpecimenHistory", streamPatientSpecimen);
            report.LoadSubreportDefinition("PatientTestingHistory", streamPatientTesting);
            report.LoadSubreportDefinition("PatientUnitAssignmentHistory", streamPatientAssignment);
            report.LoadSubreportDefinition("PatientTransfusionHistory", streamPatientTransfusion);
            report.LoadSubreportDefinition("PatientTransfusionReactionHistory", streamPatientTransfusionReaction);
            report.LoadSubreportDefinition("PatientTransfusionRequirementsHistory", streamPatientTransfusionRequirements);
            report.LoadSubreportDefinition("PatientSpecialInstructionsHistory", streamPatientSpecialInstructions);
            report.LoadSubreportDefinition("ExceptionPatientAboRh", streamExceptionPatientAboRh);
            report.LoadSubreportDefinition("ExceptionPatientAboRhDiscrepancy", streamExceptionPatientAboRhDiscrepancy);
            report.LoadSubreportDefinition("ExceptionPatientAntigenDiscrepancy", streamExceptionPatientAntigenDiscrepancy);
            report.LoadSubreportDefinition("ExceptionPatientTest", streamExceptionPatientTest);
            report.LoadSubreportDefinition("ExceptionPatientTestInactivated", streamExceptionPatientTestInactivated);
            report.LoadSubreportDefinition("ExceptionQCNotPerformed", streamExceptionQCNotPerformed);
            report.LoadSubreportDefinition("ExceptionQC", streamExceptionQC);
            report.LoadSubreportDefinition("ExceptionReflexTest", streamExceptionReflexTest);
            report.LoadSubreportDefinition("ExceptionSpecimen", streamExceptionSpecimen);
            report.LoadSubreportDefinition("ExceptionUnitSelection", streamExceptionUnitSelection);
            report.LoadSubreportDefinition("ExceptionTrwSpecimen", streamExceptionTrwSpecimen);
            report.LoadSubreportDefinition("ExceptionTransfusionReactionWorkup", streamExceptionTransfusionReactionWorkup);
            //CR 3355 Fixed spelling of the CautionTag Exception subreport
            report.LoadSubreportDefinition("ExceptionCautionTagBTRFPrinting", streamExceptionCautionTagBTRFPrinting);
            report.LoadSubreportDefinition("ExceptionReturnIssuedUnit", streamExceptionReturnIssuedUnit);
            report.LoadSubreportDefinition("ExceptionTransfusion", streamExceptionTransfusion);
            report.LoadSubreportDefinition("ExceptionUnitIssue", streamExceptionUnitIssue);
            report.LoadSubreportDefinition("ExceptionEmergencyIssueOrder", streamExceptionEmergencyIssueOrder);
            report.LoadSubreportDefinition("ExceptionUnitERIssuedTestingProblem", streamExceptionUnitERIssuedTestingProblem);
            report.LoadSubreportDefinition("ExceptionPatientRestriction", streamExceptionPatientRestriction);

            return new BOL.VbecsReportPrinter(this.PrinterName, true, report);
        }

        private void LoadSubreportsEventHandler(object sender, SubreportProcessingEventArgs e)
        {
            if (e.ReportPath == "PatientDemographicHistory" || e.DataSourceNames[0].ToString() == "PatientDemographicHistoryDataSet")
            {
                ReportDataSource reportSourcePatientDemographic = new ReportDataSource();
                if (this.IncludePatientDemographics)
                {
                    reportSourcePatientDemographic.Name = "PatientDemographicHistoryDataSet";
                    reportSourcePatientDemographic.Value = this._dsReportData.Tables[Common.VbecsTables.Patient.TableName];
                }
                e.DataSources.Add(reportSourcePatientDemographic);
            }
            else if (e.ReportPath == "PatientAboRHHistory" || e.DataSourceNames[0].ToString() == "PatientAboRHHistoryDataSet")
            {
                ReportDataSource reportSourcePatientAboRH = new ReportDataSource();
                if (this.IncludePatientDemographics)
                {
                    reportSourcePatientAboRH.Name = "PatientAboRHHistoryDataSet";
                    reportSourcePatientAboRH.Value = this._dsReportData.Tables[Common.VbecsTables.Compatibility.PatientAboRh];
                }
                e.DataSources.Add(reportSourcePatientAboRH);
            }
            else if (e.ReportPath == "PatientSpecimenHistory" || e.DataSourceNames[0].ToString() == "PatientSpecimenHistoryDataSet")
            {
                ReportDataSource reportSourcePatientSpecimen = new ReportDataSource();
                if (this.IncludePatientSpecimens)
                {
                    reportSourcePatientSpecimen.Name = "PatientSpecimenHistoryDataSet";
                    reportSourcePatientSpecimen.Value = this._dsReportData.Tables[Common.VbecsTables.PatientSpecimen.TableName];
                }
                e.DataSources.Add(reportSourcePatientSpecimen);
            }
            else if (e.ReportPath == "PatientTestingHistory" || e.DataSourceNames[0].ToString() == "PatientTestingHistoryDataSet")
            {
                ReportDataSource reportSourcePatientTesting = new ReportDataSource();
                if (this.IncludePatientTesting)
                {
                    reportSourcePatientTesting.Name = "PatientTestingHistoryDataSet";
                    reportSourcePatientTesting.Value = this._dsReportData.Tables[Common.VbecsTables.SpecimenTest.TableName];
                }
                e.DataSources.Add(reportSourcePatientTesting);
            }
            else if (e.ReportPath == "PatientUnitAssignmentHistory" || e.DataSourceNames[0].ToString() == "PatientUnitAssignmentHistoryDataSet")
            {
                ReportDataSource reportSourcePatientAssignment = new ReportDataSource();
                if (this.IncludePatientUnitAssignments)
                {
                    reportSourcePatientAssignment.Name = "PatientUnitAssignmentHistoryDataSet";
                    reportSourcePatientAssignment.Value = this._dsReportData.Tables[Common.VbecsTables.OrderedUnit.TableName];
                }
                e.DataSources.Add(reportSourcePatientAssignment);
            }
            else if (e.ReportPath == "PatientTransfusionHistory" || e.DataSourceNames[0].ToString() == "PatientTransfusionHistoryDataSet")
            {
                ReportDataSource reportSourcePatientTransfusion = new ReportDataSource();
                if (this.IncludePatientTransfusions)
                {
                    reportSourcePatientTransfusion.Name = "PatientTransfusionHistoryDataSet";
                    reportSourcePatientTransfusion.Value = this._dsReportData.Tables[Common.VbecsTables.PatientTransfusion.TableName];
                }
                e.DataSources.Add(reportSourcePatientTransfusion);
            }
            else if (e.ReportPath == "PatientTransfusionReactionHistory" || e.DataSourceNames[0].ToString() == "PatientTransfusionReactionHistoryDataSet")
            {
                ReportDataSource reportSourcePatientTransfusionReaction = new ReportDataSource();
                ReportDataSource reportSourceReportSections = new ReportDataSource();
                if (this.IncludePatientTransfusionReactions)
                {
                    reportSourcePatientTransfusionReaction.Name = "PatientTransfusionReactionHistoryDataSet";
                    reportSourcePatientTransfusionReaction.Value = this._dsReportData.Tables[Common.VbecsTables.PatientTransfusionReaction.TableName];
                    reportSourceReportSections.Name = "PatientHistoryReportDataSet";
                    reportSourceReportSections.Value = this._dsReportData.Tables["ReportSections"];
                }
                e.DataSources.Add(reportSourcePatientTransfusionReaction);
                e.DataSources.Add(reportSourceReportSections);
            }
            else if (e.ReportPath == "PatientTransfusionRequirementsHistory" || e.DataSourceNames[0].ToString() == "PatientTransfusionRequirementsHistoryDataSet")
            {
                ReportDataSource reportSourcePatientTransfusionRequirements = new ReportDataSource();
                if (this.IncludePatientTransfusionRequirements)
                {
                    reportSourcePatientTransfusionRequirements.Name = "PatientTransfusionRequirementsHistoryDataSet";
                    reportSourcePatientTransfusionRequirements.Value = this._dsReportData.Tables[Common.VbecsTables.PatientTransfusionRequirement.TableName];
                }
                e.DataSources.Add(reportSourcePatientTransfusionRequirements);
            }
            else if (e.ReportPath == "PatientSpecialInstructionsHistory" || e.DataSourceNames[0].ToString() == "PatientSpecialInstructionsHistoryDataSet")
            {
                ReportDataSource reportSourcePatientSpecialInstructions = new ReportDataSource();
                if (this.IncludePatientSpecialInstructions)
                {
                    reportSourcePatientSpecialInstructions.Name = "PatientSpecialInstructionsHistoryDataSet";
                    reportSourcePatientSpecialInstructions.Value = this._dsReportData.Tables[Common.VbecsTables.PatientSpecialInstruction.TableName];
                }
                e.DataSources.Add(reportSourcePatientSpecialInstructions);
            }
            else if (e.ReportPath == "ExceptionPatientAboRh" || e.DataSourceNames[0].ToString() == "ExceptionPatientAboRhDataSet")
            {
                ReportDataSource reportSourceExceptionPatientAboRh = new ReportDataSource();
                if (this.IncludePatientExceptionReports)
                {
                    reportSourceExceptionPatientAboRh.Name = "ExceptionPatientAboRhDataSet";
                    reportSourceExceptionPatientAboRh.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportPatientAboRh.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionPatientAboRh);
            }
            else if (e.ReportPath == "ExceptionPatientAboRhDiscrepancy" || e.DataSourceNames[0].ToString() == "ExceptionPatientAboRhDiscrepancyDataSet")
            {
                ReportDataSource reportSourceExceptionPatientAboRhDiscrepancy = new ReportDataSource();
                if (this.IncludePatientExceptionReports)
                {
                    reportSourceExceptionPatientAboRhDiscrepancy.Name = "ExceptionPatientAboRhDiscrepancyDataSet";
                    reportSourceExceptionPatientAboRhDiscrepancy.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportPatientAboRhDiscrepancy.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionPatientAboRhDiscrepancy);
            }
            else if (e.ReportPath == "ExceptionPatientAntigenDiscrepancy" || e.DataSourceNames[0].ToString() == "ExceptionPatientAntigenDiscrepancyDataSet")
            {
                ReportDataSource reportSourceExceptionPatientAntigenDiscrepancy = new ReportDataSource();
                if (this.IncludePatientExceptionReports)
                {
                    reportSourceExceptionPatientAntigenDiscrepancy.Name = "ExceptionPatientAntigenDiscrepancyDataSet";
                    reportSourceExceptionPatientAntigenDiscrepancy.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportPatientAntigenDiscrepancy.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionPatientAntigenDiscrepancy);
            }
            else if (e.ReportPath == "ExceptionPatientTest" || e.DataSourceNames[0].ToString() == "ExceptionPatientTestDataSet")
            {
                ReportDataSource reportSourceExceptionPatientTest = new ReportDataSource();
                if (this.IncludePatientExceptionReports)
                {
                    reportSourceExceptionPatientTest.Name = "ExceptionPatientTestDataSet";
                    reportSourceExceptionPatientTest.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportPatientTest.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionPatientTest);
            }
            else if (e.ReportPath == "ExceptionPatientTestInactivated" || e.DataSourceNames[0].ToString() == "ExceptionPatientTestInactivatedDataSet")
            {
                ReportDataSource reportSourceExceptionPatientTestInactivated = new ReportDataSource();
                if (this.IncludePatientExceptionReports)
                {
                    reportSourceExceptionPatientTestInactivated.Name = "ExceptionPatientTestInactivatedDataSet";
                    reportSourceExceptionPatientTestInactivated.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportPatientTestInactivated.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionPatientTestInactivated);
            }
            else if (e.ReportPath == "ExceptionQCNotPerformed" || e.DataSourceNames[0].ToString() == "ExceptionQCNotPerformedDataSet")
            {
                ReportDataSource reportSourceExceptionQCNotPerformed = new ReportDataSource();
                if (this.IncludePatientExceptionReports)
                {
                    reportSourceExceptionQCNotPerformed.Name = "ExceptionQCNotPerformedDataSet";
                    reportSourceExceptionQCNotPerformed.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportQCNotPerformed.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionQCNotPerformed);
            }
            else if (e.ReportPath == "ExceptionQC" || e.DataSourceNames[0].ToString() == "ExceptionQCDataSet")
            {
                ReportDataSource reportSourceExceptionQC = new ReportDataSource();
                if (this.IncludePatientExceptionReports)
                {
                    reportSourceExceptionQC.Name = "ExceptionQCDataSet";
                    reportSourceExceptionQC.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportQC.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionQC);
            }
            else if (e.ReportPath == "ExceptionReflexTest" || e.DataSourceNames[0].ToString() == "ExceptionReflexTestDataSet")
            {
                ReportDataSource reportSourceExceptionReflexTest = new ReportDataSource();
                if (this.IncludePatientExceptionReports)
                {
                    reportSourceExceptionReflexTest.Name = "ExceptionReflexTestDataSet";
                    reportSourceExceptionReflexTest.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportReflexTest.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionReflexTest);
            }
            else if (e.ReportPath == "ExceptionSpecimen" || e.DataSourceNames[0].ToString() == "ExceptionSpecimenDataSet")
            {
                ReportDataSource reportSourceExceptionSpecimen = new ReportDataSource();
                if (this.IncludePatientExceptionReports)
                {
                    reportSourceExceptionSpecimen.Name = "ExceptionSpecimenDataSet";
                    reportSourceExceptionSpecimen.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportSpecimen.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionSpecimen);
            }
            else if (e.ReportPath == "ExceptionUnitSelection" || e.DataSourceNames[0].ToString() == "ExceptionUnitSelectionDataSet")
            {
                ReportDataSource reportSourceExceptionUnitSelection = new ReportDataSource();
                if (this.IncludePatientExceptionReports)
                {
                    reportSourceExceptionUnitSelection.Name = "ExceptionUnitSelectionDataSet";
                    reportSourceExceptionUnitSelection.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportUnitSelection.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionUnitSelection);
            }
            else if (e.ReportPath == "ExceptionTrwSpecimen" || e.DataSourceNames[0].ToString() == "ExceptionTrwSpecimenDataSet")
            {
                ReportDataSource reportSourceExceptionTrwSpecimen = new ReportDataSource();
                if (this.IncludePatientExceptionReports)
                {
                    reportSourceExceptionTrwSpecimen.Name = "ExceptionTrwSpecimenDataSet";
                    reportSourceExceptionTrwSpecimen.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportTrwSpecimen.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionTrwSpecimen);
            }
            else if (e.ReportPath == "ExceptionTransfusionReactionWorkup" || e.DataSourceNames[0].ToString() == "ExceptionTransfusionReactionWorkupDataSet")
            {
                ReportDataSource reportSourceExceptionTransfusionReactionWorkup = new ReportDataSource();
                if (this.IncludePatientExceptionReports)
                {
                    reportSourceExceptionTransfusionReactionWorkup.Name = "ExceptionTransfusionReactionWorkupDataSet";
                    reportSourceExceptionTransfusionReactionWorkup.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportTransfusionReactionWorkup.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionTransfusionReactionWorkup);
            }
            else if (e.ReportPath == "ExceptionCautionTagBTRFPrinting" || e.DataSourceNames[0].ToString() == "ExceptionCautionTagBTRFPrintingDataSet")
            {
                ReportDataSource reportSourceExceptionCautionTagBTRFPrinting = new ReportDataSource();
                if (this.IncludePatientExceptionReports)
                {
                    reportSourceExceptionCautionTagBTRFPrinting.Name = "ExceptionCautionTagBTRFPrintingDataSet";
                    reportSourceExceptionCautionTagBTRFPrinting.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportCautionTagBTRFPrinting.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionCautionTagBTRFPrinting);
            }
            else if (e.ReportPath == "ExceptionReturnIssuedUnit" || e.DataSourceNames[0].ToString() == "ExceptionReturnIssuedUnitDataSet")
            {
                ReportDataSource reportSourceExceptionReturnIssuedUnit = new ReportDataSource();
                if (this.IncludePatientExceptionReports)
                {
                    reportSourceExceptionReturnIssuedUnit.Name = "ExceptionReturnIssuedUnitDataSet";
                    reportSourceExceptionReturnIssuedUnit.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportReturnIssuedUnit.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionReturnIssuedUnit);
            }
            else if (e.ReportPath == "ExceptionTransfusion" || e.DataSourceNames[0].ToString() == "ExceptionTransfusionDataSet")
            {
                ReportDataSource reportSourceExceptionTransfusion = new ReportDataSource();
                if (this.IncludePatientExceptionReports)
                {
                    reportSourceExceptionTransfusion.Name = "ExceptionTransfusionDataSet";
                    reportSourceExceptionTransfusion.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportTransfusion.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionTransfusion);
            }
            else if (e.ReportPath == "ExceptionUnitIssue" || e.DataSourceNames[0].ToString() == "ExceptionUnitIssueDataSet")
            {
                ReportDataSource reportSourceExceptionUnitIssue = new ReportDataSource();
                if (this.IncludePatientExceptionReports)
                {
                    reportSourceExceptionUnitIssue.Name = "ExceptionUnitIssueDataSet";
                    reportSourceExceptionUnitIssue.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportUnitIssue.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionUnitIssue);
            }
            else if (e.ReportPath == "ExceptionEmergencyIssueOrder" || e.DataSourceNames[0].ToString() == "ExceptionEmergencyIssueOrderDataSet")
            {
                ReportDataSource reportSourceExceptionEmergencyIssueOrder = new ReportDataSource();
                if (this.IncludePatientExceptionReports)
                {
                    reportSourceExceptionEmergencyIssueOrder.Name = "ExceptionEmergencyIssueOrderDataSet";
                    reportSourceExceptionEmergencyIssueOrder.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportEmergencyIssueOrder.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionEmergencyIssueOrder);
            }
            else if (e.ReportPath == "ExceptionUnitERIssuedTestingProblem" || e.DataSourceNames[0].ToString() == "ExceptionUnitERIssuedTestingProblemDataSet")
            {
                ReportDataSource reportSourceExceptionUnitERIssuedTestingProblem = new ReportDataSource();
                if (this.IncludePatientExceptionReports)
                {
                    reportSourceExceptionUnitERIssuedTestingProblem.Name = "ExceptionUnitERIssuedTestingProblemDataSet";
                    reportSourceExceptionUnitERIssuedTestingProblem.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportUnitERIssuedTestingProblem.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionUnitERIssuedTestingProblem);
            }
            else if (e.ReportPath == "ExceptionPatientRestriction" || e.DataSourceNames[0].ToString() == "ExceptionPatientRestrictionDataSet")
            {
                ReportDataSource reportSourceExceptionPatientRestriction = new ReportDataSource();
                if (this.IncludePatientExceptionReports)
                {
                    reportSourceExceptionPatientRestriction.Name = "ExceptionPatientRestrictionDataSet";
                    reportSourceExceptionPatientRestriction.Value = this._dsReportData.Tables[Common.ExceptionReportType.ExceptionReportPatientRestriction.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionPatientRestriction);
            }
        }

	}
}
